/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import java.util.Date;

public class STSSessionCredentialsProvider
implements AWSCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private final AWSSecurityTokenService securityTokenService;
    private AWSSessionCredentials sessionCredentials;
    private Date sessionCredentialsExpiration;

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials) {
        this(longLivedCredentials, new ClientConfiguration());
    }

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials, ClientConfiguration clientConfiguration) {
        this.securityTokenService = new AWSSecurityTokenServiceClient(longLivedCredentials, clientConfiguration);
    }

    public STSSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider) {
        this.securityTokenService = new AWSSecurityTokenServiceClient(longLivedCredentialsProvider);
    }

    public AWSCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    public void refresh() {
        this.startSession();
    }

    private void startSession() {
        GetSessionTokenResult sessionTokenResult = this.securityTokenService.getSessionToken(new GetSessionTokenRequest().withDurationSeconds(3600));
        Credentials stsCredentials = sessionTokenResult.getCredentials();
        this.sessionCredentials = new BasicSessionCredentials(stsCredentials.getAccessKeyId(), stsCredentials.getSecretAccessKey(), stsCredentials.getSessionToken());
        this.sessionCredentialsExpiration = stsCredentials.getExpiration();
    }

    private boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long timeRemaining = this.sessionCredentialsExpiration.getTime() - System.currentTimeMillis();
        return timeRemaining < 60000L;
    }
}

