/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSnapshotRequestMarshaller
implements Marshaller<Request<CreateSnapshotRequest>, CreateSnapshotRequest> {
    @Override
    public Request<CreateSnapshotRequest> marshall(CreateSnapshotRequest createSnapshotRequest) {
        if (createSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateSnapshotRequest> request = new DefaultRequest<CreateSnapshotRequest>(createSnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "CreateSnapshot");
        request.addParameter("Version", "2011-11-01");
        if (createSnapshotRequest.getVolumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString(createSnapshotRequest.getVolumeId()));
        }
        if (createSnapshotRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createSnapshotRequest.getDescription()));
        }
        return request;
    }
}

