/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.RiemannTcpClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class RiemannRetryingTcpClient
extends RiemannTcpClient {
    protected final Object reconnectionLock = new Object();
    protected long lastReconnectionAttempt = 0L;
    public volatile long minimumReconnectInterval = 1L;
    protected volatile boolean reconnecting = false;

    public RiemannRetryingTcpClient() throws UnknownHostException {
    }

    public RiemannRetryingTcpClient(int port) throws UnknownHostException {
        super(port);
    }

    public RiemannRetryingTcpClient(InetSocketAddress server) {
        super(server);
    }

    @Override
    public Proto.Msg sendRecvMessage(Proto.Msg m) throws IOException {
        try {
            return super.sendRecvMessage(m);
        }
        catch (IOException e) {
            this.reconnect();
            return super.sendRecvMessage(m);
        }
    }

    public void setMinimumReconnectInterval(long interval) {
        if (interval < 0L) {
            throw new IllegalArgumentException("Invalid interval time");
        }
        this.minimumReconnectInterval = interval * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() throws IOException {
        Object object = this.reconnectionLock;
        synchronized (object) {
            long latestAttempt = System.currentTimeMillis() - this.lastReconnectionAttempt;
            if (this.reconnecting || latestAttempt <= this.minimumReconnectInterval) {
                return;
            }
            this.reconnecting = true;
            this.lastReconnectionAttempt = System.currentTimeMillis();
        }
        try {
            object = this.socketLock;
            synchronized (object) {
                this.disconnect();
                this.connect();
            }
        }
        finally {
            object = this.reconnectionLock;
            synchronized (object) {
                this.reconnecting = false;
            }
        }
    }
}

