/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.AbstractRiemannClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class RiemannTcpClient
extends AbstractRiemannClient {
    protected Socket socket;
    protected final Object socketLock = new Object();
    protected DataOutputStream out;
    protected DataInputStream in;
    public static final int connectTimeout = 1000;
    public static final int readTimeout = 1000;

    public RiemannTcpClient() throws UnknownHostException {
    }

    public RiemannTcpClient(int port) throws UnknownHostException {
        super(port);
    }

    public RiemannTcpClient(InetSocketAddress server) {
        super(server);
    }

    @Override
    public void sendMessage(Proto.Msg message) throws IOException {
        if (message == null) {
            throw new IllegalArgumentException("Null message");
        }
        this.out.writeInt(message.getSerializedSize());
        message.writeTo(this.out);
        this.out.flush();
    }

    @Override
    public Proto.Msg recvMessage() throws IOException {
        int len = this.in.readInt();
        if (len < 0) {
            throw new IOException("FUCKED");
        }
        byte[] body = new byte[len];
        this.in.readFully(body);
        return Proto.Msg.parseFrom(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Proto.Msg sendRecvMessage(Proto.Msg message) throws IOException {
        Object object = this.socketLock;
        synchronized (object) {
            this.sendMessage(message);
            return this.recvMessage();
        }
    }

    @Override
    public Proto.Msg sendMaybeRecvMessage(Proto.Msg message) throws IOException {
        return this.sendRecvMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.socketLock;
        synchronized (object) {
            return this.socket != null && this.socket.isConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        Object object = this.socketLock;
        synchronized (object) {
            this.socket = new Socket();
            this.socket.connect(this.server, 1000);
            this.socket.setSoTimeout(1000);
            this.socket.setTcpNoDelay(true);
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.in = new DataInputStream(this.socket.getInputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        Object object = this.socketLock;
        synchronized (object) {
            this.out.close();
            this.in.close();
            this.socket.close();
        }
    }
}

