/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.MsgTooLargeException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class RiemannUDPClient
extends AbstractRiemannClient {
    protected static final int MAX_SIZE = 16384;

    public RiemannUDPClient() throws UnknownHostException {
    }

    public RiemannUDPClient(int port) throws UnknownHostException {
        super(port);
    }

    public RiemannUDPClient(InetSocketAddress server) {
        super(server);
    }

    public boolean canSendMessage(Proto.Msg message) {
        return message.getSerializedSize() <= 16384;
    }

    @Override
    public void sendMessage(Proto.Msg message) throws IOException, MsgTooLargeException {
        if (message.getSerializedSize() > 16384) {
            throw new MsgTooLargeException();
        }
        byte[] buf = message.toByteArray();
        DatagramSocket socket = new DatagramSocket();
        socket.send(new DatagramPacket(buf, buf.length, this.server));
        socket.close();
    }

    @Override
    public Proto.Msg recvMessage() throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public Proto.Msg sendRecvMessage(Proto.Msg message) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public Proto.Msg sendMaybeRecvMessage(Proto.Msg message) throws IOException, MsgTooLargeException {
        this.sendMessage(message);
        return null;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void disconnect() throws IOException {
    }
}

