/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.MsgTooLargeException;
import com.aphyr.riemann.client.RiemannRetryingTcpClient;
import com.aphyr.riemann.client.RiemannUDPClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class RiemannClient
extends AbstractRiemannClient {
    public final RiemannRetryingTcpClient tcp;
    public final RiemannUDPClient udp;
    public static RiemannClient singletonClient;

    public static RiemannClient getClient() {
        return singletonClient;
    }

    public static void setClient(RiemannClient client) {
        singletonClient = client;
    }

    public RiemannClient(InetSocketAddress server) {
        super(server);
        this.udp = new RiemannUDPClient(server);
        this.tcp = new RiemannRetryingTcpClient(server);
    }

    public RiemannClient(int port) throws UnknownHostException {
        this(new InetSocketAddress(InetAddress.getLocalHost(), port));
    }

    public RiemannClient() throws UnknownHostException {
        this(new InetSocketAddress(InetAddress.getLocalHost(), 5555));
    }

    @Override
    public void sendMessage(Proto.Msg message) {
        throw new NotImplementedException();
    }

    @Override
    public Proto.Msg recvMessage() {
        throw new NotImplementedException();
    }

    @Override
    public Proto.Msg sendRecvMessage(Proto.Msg message) throws IOException {
        return this.tcp.sendRecvMessage(message);
    }

    @Override
    public Proto.Msg sendMaybeRecvMessage(Proto.Msg message) throws IOException {
        try {
            if (this.udp.canSendMessage(message)) {
                return this.udp.sendMaybeRecvMessage(message);
            }
            return this.tcp.sendMaybeRecvMessage(message);
        }
        catch (MsgTooLargeException e) {
            return this.tcp.sendMaybeRecvMessage(message);
        }
    }

    @Override
    public boolean isConnected() {
        return this.udp.isConnected() && this.tcp.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        RiemannClient riemannClient = this;
        synchronized (riemannClient) {
            this.udp.connect();
            this.tcp.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        RiemannClient riemannClient = this;
        synchronized (riemannClient) {
            this.udp.disconnect();
            this.tcp.disconnect();
        }
    }
}

