/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey;

import clojure.lang.ExceptionInfo;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.RT;
import com.appsflyer.donkey.CompletableResult;
import io.vertx.core.Future;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public final class FutureResult<T>
implements CompletableResult<T>,
IDeref {
    private final CompletableFuture<Object> impl;

    public static <V> FutureResult<V> create() {
        return new FutureResult(new CompletableFuture<Object>());
    }

    public static <V> FutureResult<V> create(V value) {
        return new FutureResult(CompletableFuture.completedFuture(value));
    }

    public static <V> FutureResult<V> create(Future<V> vertxFuture) {
        CompletableFuture<Object> impl = new CompletableFuture<Object>();
        vertxFuture.onComplete(event -> {
            if (event.succeeded()) {
                impl.complete(event.result());
            } else {
                impl.completeExceptionally(event.cause());
            }
        });
        return new FutureResult(impl);
    }

    private FutureResult(CompletableFuture<Object> impl) {
        this.impl = impl;
    }

    @Override
    public CompletableResult<T> onComplete(IFn handler) {
        return new FutureResult<T>((CompletableFuture<Object>)this.impl.whenComplete((arg_0, arg_1) -> ((IFn)handler).invoke(arg_0, arg_1)));
    }

    @Override
    public CompletableResult<T> onSuccess(IFn handler) {
        return new FutureResult<T>((CompletableFuture<Object>)this.impl.thenApply(arg_0 -> ((IFn)handler).invoke(arg_0)));
    }

    @Override
    public CompletableResult<T> onFail(IFn handler) {
        return new FutureResult<T>((CompletableFuture<Object>)this.impl.exceptionally(arg_0 -> ((IFn)handler).invoke(arg_0)));
    }

    public Object deref() {
        try {
            return this.impl.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ExceptionInfo(e.getMessage(), RT.map((Object[])new Object[0]), (Throwable)e);
        }
        catch (ExecutionException e) {
            return new ExceptionInfo(e.getCause().getMessage(), RT.map((Object[])new Object[0]), e.getCause());
        }
    }
}

