/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.client.ring;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import com.appsflyer.donkey.ValueExtractor;
import com.appsflyer.donkey.util.TypeConverter;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import org.jetbrains.annotations.Nullable;

public enum RingResponseField implements ValueExtractor<HttpResponse<Buffer>>
{
    STATUS("status"){

        public Integer from(HttpResponse<Buffer> res) {
            return res.statusCode();
        }
    }
    ,
    HEADERS("headers"){

        @Nullable
        public IPersistentMap from(HttpResponse<Buffer> res) {
            MultiMap headers = res.headers();
            if (headers.isEmpty()) {
                return null;
            }
            return TypeConverter.toPersistentMap(headers, TypeConverter::stringJoiner);
        }
    }
    ,
    BODY("body"){

        public byte[] from(HttpResponse<Buffer> res) {
            Buffer body = (Buffer)res.body();
            if (body != null) {
                return body.getBytes();
            }
            return BYTES;
        }
    };

    private static final byte[] BYTES;
    private final Keyword keyword;

    private RingResponseField(String field) {
        this.keyword = Keyword.intern((String)field);
    }

    public Keyword keyword() {
        return this.keyword;
    }

    static {
        BYTES = new byte[0];
    }
}

