/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.log;

import com.appsflyer.donkey.log.LogbackLogger;
import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.core.spi.logging.LogDelegateFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class LogbackLoggerFactory {
    private static volatile LogDelegateFactory delegateFactory;
    private static final Map<String, LogbackLogger> loggers;
    private static final String FACTORY_DELEGATE_CLASS_NAME = "com.appsflyer.donkey.log.LogbackDelegateFactory";

    private LogbackLoggerFactory() {
    }

    public static synchronized void initialize() {
        LogDelegateFactory delegateFactory;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clz = loader.loadClass(FACTORY_DELEGATE_CLASS_NAME);
            delegateFactory = (LogDelegateFactory)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error instantiating transformer class \"%s\"", FACTORY_DELEGATE_CLASS_NAME), e);
        }
        LogbackLoggerFactory.delegateFactory = delegateFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        String name = clazz.isAnonymousClass() ? clazz.getEnclosingClass().getCanonicalName() : clazz.getCanonicalName();
        return LogbackLoggerFactory.getLogger(name);
    }

    public static LogbackLogger getLogger(String name) {
        LogDelegate delegate;
        LogbackLogger oldLogger;
        LogbackLogger logger = loggers.get(name);
        if (logger == null && (oldLogger = loggers.putIfAbsent(name, logger = new LogbackLogger(delegate = delegateFactory.createDelegate(name)))) != null) {
            logger = oldLogger;
        }
        return logger;
    }

    public static void removeLogger(String name) {
        loggers.remove(name);
    }

    static {
        loggers = new ConcurrentHashMap<String, LogbackLogger>(10);
        LogbackLoggerFactory.initialize();
    }
}

