/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server;

import com.appsflyer.donkey.server.ServerConfig;
import com.appsflyer.donkey.server.ServerConfigBuilder;
import com.appsflyer.donkey.server.route.RouteCreatorFactory;
import com.appsflyer.donkey.server.route.RouteList;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import java.util.Objects;

public final class ServerConfigImpl
implements ServerConfig {
    private Vertx vertx;
    private HttpServerOptions serverOptions;
    private RouteCreatorFactory routeCreatorFactory;
    private RouteList routeList;
    private int instances;
    private boolean debug;
    private boolean addDateHeader;
    private boolean addContentTypeHeader;
    private boolean addServerHeader;

    private ServerConfigImpl() {
    }

    @Override
    public Vertx vertx() {
        return this.vertx;
    }

    @Override
    public HttpServerOptions serverOptions() {
        return this.serverOptions;
    }

    @Override
    public RouteCreatorFactory routeCreatorFactory() {
        return this.routeCreatorFactory;
    }

    @Override
    public RouteList routeList() {
        return this.routeList;
    }

    @Override
    public int instances() {
        return this.instances;
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    @Override
    public boolean addDateHeader() {
        return this.addDateHeader;
    }

    @Override
    public boolean addContentTypeHeader() {
        return this.addContentTypeHeader;
    }

    @Override
    public boolean addServerHeader() {
        return this.addServerHeader;
    }

    public static final class ServerConfigBuilderImpl
    implements ServerConfigBuilder {
        private ServerConfigImpl instance = new ServerConfigImpl();

        ServerConfigBuilderImpl() {
        }

        @Override
        public ServerConfigBuilder vertx(Vertx vertx) {
            this.instance.vertx = vertx;
            return this;
        }

        @Override
        public ServerConfigBuilder serverOptions(HttpServerOptions serverOptions) {
            this.instance.serverOptions = serverOptions;
            return this;
        }

        @Override
        public ServerConfigBuilder routeCreatorFactory(RouteCreatorFactory routeCreatorFactory) {
            this.instance.routeCreatorFactory = routeCreatorFactory;
            return this;
        }

        @Override
        public ServerConfigBuilder routeList(RouteList routeList) {
            this.instance.routeList = routeList;
            return this;
        }

        @Override
        public ServerConfigBuilder instances(int val) {
            this.instance.instances = val;
            return this;
        }

        @Override
        public ServerConfigBuilder debug(boolean val) {
            this.instance.debug = val;
            return this;
        }

        @Override
        public ServerConfigBuilder addDateHeader(boolean val) {
            this.instance.addDateHeader = val;
            return this;
        }

        @Override
        public ServerConfigBuilder addContentTypeHeader(boolean val) {
            this.instance.addContentTypeHeader = val;
            return this;
        }

        @Override
        public ServerConfigBuilder addServerHeader(boolean val) {
            this.instance.addServerHeader = val;
            return this;
        }

        @Override
        public ServerConfig build() {
            this.assertValidState();
            ServerConfigImpl res = this.instance;
            this.instance = null;
            return res;
        }

        private void assertValidState() {
            Objects.requireNonNull(this.instance.vertx, "Vert.x instance is missing");
            Objects.requireNonNull(this.instance.serverOptions, "Server options is missing");
            Objects.requireNonNull(this.instance.routeCreatorFactory, "Route creator factory is missing");
            Objects.requireNonNull(this.instance.routeList, "Router definition list is missing");
            if (this.instance.instances < 1) {
                throw new IllegalArgumentException("Number of instances must be greater than 0");
            }
        }
    }
}

