/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.middleware;

import clojure.lang.Counted;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import com.appsflyer.donkey.server.ring.middleware.QueryParamsParser;
import com.appsflyer.donkey.server.ring.middleware.RingMiddleware;
import java.util.Iterator;
import java.util.Objects;

public class QueryParamsKeywordizer
implements RingMiddleware {
    private static final Keyword QUERY_PARAMS = Keyword.intern((String)"query-params");
    private static final Object NOT_FOUND = new Object();

    public static RingMiddleware getInstance() {
        return MiddlewareHolder.instance;
    }

    @Override
    public IPersistentMap handle(IPersistentMap request) {
        Objects.requireNonNull(request, "Request map cannot be null");
        IPersistentMap localRequest = request;
        Object queryParams = localRequest.valAt((Object)QUERY_PARAMS, NOT_FOUND);
        if (queryParams == NOT_FOUND) {
            localRequest = QueryParamsParser.getInstance().handle(localRequest);
            queryParams = localRequest.valAt((Object)QUERY_PARAMS);
        }
        if (queryParams == null) {
            return localRequest;
        }
        int size = ((Counted)queryParams).count();
        if (size == 0) {
            return localRequest;
        }
        IPersistentMap params = (IPersistentMap)queryParams;
        Object[] res = new Object[params.count() * 2];
        Iterator iter = params.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IMapEntry entry = (IMapEntry)iter.next();
            res[i] = Keyword.intern((String)((String)entry.getKey()));
            res[i + 1] = entry.getValue();
            i += 2;
        }
        return localRequest.assoc((Object)QUERY_PARAMS, (Object)RT.mapUniqueKeys((Object[])res));
    }

    private static class MiddlewareHolder {
        private static final RingMiddleware instance = new QueryParamsKeywordizer();

        private MiddlewareHolder() {
        }
    }
}

