/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.middleware;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import com.appsflyer.donkey.server.ring.handler.RingRequestField;
import com.appsflyer.donkey.server.ring.middleware.RingMiddleware;
import com.appsflyer.donkey.util.TypeConverter;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryParamsParser
implements RingMiddleware {
    private static final Keyword QUERY_PARAMS = Keyword.intern((String)"query-params");

    public static RingMiddleware getInstance() {
        return MiddlewareHolder.instance;
    }

    @Override
    public IPersistentMap handle(IPersistentMap request) {
        Objects.requireNonNull(request, "Request map cannot be null");
        if (request.containsKey((Object)QUERY_PARAMS)) {
            return request;
        }
        String queryString = (String)request.valAt((Object)RingRequestField.QUERY_STRING.keyword(), null);
        if (queryString == null || queryString.isBlank()) {
            return request;
        }
        Map decodedParams = new QueryStringDecoder(queryString, false).parameters();
        Object[] values = new Object[decodedParams.size() * 2];
        int i = 0;
        for (Map.Entry entry : decodedParams.entrySet()) {
            values[i] = entry.getKey();
            List val = (List)entry.getValue();
            values[i + 1] = val.size() > 1 ? TypeConverter.toVector(val) : val.get(0);
            i += 2;
        }
        return request.assoc((Object)QUERY_PARAMS, (Object)RT.mapUniqueKeys((Object[])values));
    }

    private static class MiddlewareHolder {
        private static final RingMiddleware instance = new QueryParamsParser();

        private MiddlewareHolder() {
        }
    }
}

