/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.client.ring;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.client.ring.ClojureRequestField;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import java.util.Objects;

public class RequestFactory {
    private final WebClient client;

    RequestFactory(WebClient client) {
        this.client = client;
    }

    public HttpRequest<Buffer> create(IPersistentMap opts) {
        HttpRequest request;
        HttpMethod method = (HttpMethod)ClojureRequestField.METHOD.from(opts);
        Objects.requireNonNull(method, "HTTP request method is missing");
        String url = (String)ClojureRequestField.URL.from(opts);
        if (url == null) {
            request = this.client.request(method, (String)ClojureRequestField.URI.from(opts));
            this.addPort((HttpRequest<Buffer>)request, opts);
            this.addHost((HttpRequest<Buffer>)request, opts);
            this.addSsl((HttpRequest<Buffer>)request, opts);
        } else {
            request = this.client.requestAbs(method, url);
        }
        this.addQueryParams((HttpRequest<Buffer>)request, opts);
        this.addHeaders((HttpRequest<Buffer>)request, opts);
        this.addBasicAuth((HttpRequest<Buffer>)request, opts);
        this.addBearerToken((HttpRequest<Buffer>)request, opts);
        this.addTimeout((HttpRequest<Buffer>)request, opts);
        return request;
    }

    private void addPort(HttpRequest<Buffer> request, IPersistentMap opts) {
        Integer port = (Integer)ClojureRequestField.PORT.from(opts);
        if (port != null) {
            request.port(port.intValue());
        }
    }

    private void addHost(HttpRequest<Buffer> request, IPersistentMap opts) {
        String host = (String)ClojureRequestField.HOST.from(opts);
        if (host != null) {
            request.host(host);
        }
    }

    private void addSsl(HttpRequest<Buffer> request, IPersistentMap opts) {
        Boolean ssl = (Boolean)ClojureRequestField.SSL.from(opts);
        if (ssl != null) {
            request.ssl(ssl);
        }
    }

    private void addTimeout(HttpRequest<Buffer> request, IPersistentMap opts) {
        Long timeout = (Long)ClojureRequestField.TIMEOUT.from(opts);
        if (timeout != null) {
            request.timeout(timeout * 1000L);
        }
    }

    private void addBearerToken(HttpRequest<Buffer> request, IPersistentMap opts) {
        String token = (String)ClojureRequestField.BEARER_TOKEN.from(opts);
        if (token != null) {
            request.bearerTokenAuthentication(token);
        }
    }

    private void addBasicAuth(HttpRequest<Buffer> request, IPersistentMap opts) {
        IPersistentMap credentials = (IPersistentMap)ClojureRequestField.BASIC_AUTH.from(opts);
        if (credentials != null) {
            request.basicAuthentication((String)credentials.valAt((Object)"id"), (String)credentials.valAt((Object)"password"));
        }
    }

    private void addQueryParams(HttpRequest<Buffer> request, IPersistentMap opts) {
        IPersistentMap params = (IPersistentMap)ClojureRequestField.QUERY_PARAMS.from(opts);
        if (params != null) {
            for (Object obj : params) {
                IMapEntry entry = (IMapEntry)obj;
                request.addQueryParam((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void addHeaders(HttpRequest<Buffer> request, IPersistentMap opts) {
        IPersistentMap headers = (IPersistentMap)ClojureRequestField.HEADERS.from(opts);
        if (headers != null) {
            for (Object obj : headers) {
                IMapEntry entry = (IMapEntry)obj;
                request.putHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
    }
}

