/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.handler;

import com.appsflyer.donkey.server.handler.PeriodicTask;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;

public final class DateHeaderHandler
implements Handler<RoutingContext>,
PeriodicTask,
Supplier<String> {
    private static final String DATE_HEADER = "Date";
    private final Vertx vertx;
    private String date;
    private Long id;

    public static DateHeaderHandler create(Vertx vertx) {
        return new DateHeaderHandler(vertx).start();
    }

    private DateHeaderHandler(Vertx vertx) {
        this.vertx = vertx;
    }

    public void handle(RoutingContext ctx) {
        ctx.addHeadersEndHandler(v -> ctx.response().putHeader(DATE_HEADER, this.date));
        ctx.next();
    }

    @Override
    public DateHeaderHandler start() {
        this.update(0L);
        this.id = this.vertx.setPeriodic(1000L, this::update);
        return this;
    }

    @Override
    public DateHeaderHandler cancel() {
        this.vertx.cancelTimer(this.id.longValue());
        return this;
    }

    @Override
    public String get() {
        return this.date;
    }

    private void update(Long timerId) {
        this.date = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now());
    }
}

