/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.handler;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import com.appsflyer.donkey.ValueExtractor;
import com.appsflyer.donkey.server.ring.handler.HttpMethodMapping;
import com.appsflyer.donkey.server.ring.handler.HttpProtocolMapping;
import com.appsflyer.donkey.util.TypeConverter;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RingRequestField implements ValueExtractor<RoutingContext>
{
    BODY("body"){

        @Nullable
        public byte[] from(RoutingContext ctx) {
            Buffer body = ctx.getBody();
            if (body != null) {
                return body.getBytes();
            }
            return null;
        }
    }
    ,
    CLIENT_CERT("ssl-client-cert"){

        @Nullable
        public Certificate[] from(RoutingContext ctx) {
            try {
                if (ctx.request().isSSL()) {
                    return ctx.request().sslSession().getPeerCertificates();
                }
            }
            catch (SSLPeerUnverifiedException e) {
                logger.warn("Caught exception getting SSL peer certificates: {}", (Object)e.getMessage());
            }
            return null;
        }
    }
    ,
    FORM_PARAMS("form-params"){

        @Nullable
        public IPersistentMap from(RoutingContext ctx) {
            if (!ctx.request().isExpectMultipart()) {
                return null;
            }
            MultiMap formAttributes = ctx.request().formAttributes();
            if (formAttributes.isEmpty()) {
                return null;
            }
            return TypeConverter.toUrlDecodedPersistentMap(formAttributes);
        }
    }
    ,
    HEADERS("headers"){
        private final Function<String, String> keyTransformer = v -> v.toLowerCase(Locale.ROOT);

        @Nullable
        public IPersistentMap from(RoutingContext ctx) {
            MultiMap headers = ctx.request().headers();
            if (headers.isEmpty()) {
                return null;
            }
            return TypeConverter.toPersistentMap(headers, this.keyTransformer, TypeConverter::stringJoiner);
        }
    }
    ,
    PATH_PARAMS("path-params"){

        @Nullable
        public IPersistentMap from(RoutingContext ctx) {
            Map pathParams = ctx.pathParams();
            if (pathParams.isEmpty()) {
                return null;
            }
            Object[] pathParamsArray = new Object[pathParams.size() * 2];
            int i = 0;
            for (Map.Entry obj : pathParams.entrySet()) {
                pathParamsArray[i] = obj.getKey();
                pathParamsArray[i + 1] = obj.getValue();
                i += 2;
            }
            return RT.mapUniqueKeys((Object[])pathParamsArray);
        }
    }
    ,
    PROTOCOL("protocol"){

        public String from(RoutingContext ctx) {
            return HttpProtocolMapping.get(ctx.request().version());
        }
    }
    ,
    QUERY_STRING("query-string"){

        public String from(RoutingContext ctx) {
            return ctx.request().query();
        }
    }
    ,
    REMOTE_ADDRESS("remote-addr"){

        @Nullable
        public String from(RoutingContext ctx) {
            String forwardedFor = ctx.request().getHeader("x-forwarded-for");
            if (forwardedFor != null) {
                return forwardedFor;
            }
            SocketAddress remoteAddress = ctx.request().remoteAddress();
            if (remoteAddress != null) {
                return remoteAddress.toString();
            }
            return null;
        }
    }
    ,
    REQUEST_METHOD("request-method"){

        public Keyword from(RoutingContext ctx) {
            return HttpMethodMapping.get(ctx.request().method());
        }
    }
    ,
    SCHEME("scheme"){
        private final Map<String, Keyword> schemeMapping = Map.of("http", Keyword.intern((String)"http"), "https", Keyword.intern((String)"https"));

        public Keyword from(RoutingContext ctx) {
            return this.schemeMapping.get(ctx.request().scheme());
        }
    }
    ,
    SERVER_NAME("server-name"){

        public String from(RoutingContext ctx) {
            return ctx.request().host();
        }
    }
    ,
    SERVER_PORT("server-port"){

        public Integer from(RoutingContext ctx) {
            return ctx.request().localAddress().port();
        }
    }
    ,
    URI("uri"){

        public String from(RoutingContext ctx) {
            return ctx.request().path();
        }
    };

    private static final Logger logger;
    private final Keyword keyword;

    private RingRequestField(String field) {
        this.keyword = Keyword.intern((String)field);
    }

    public Keyword keyword() {
        return this.keyword;
    }

    static {
        logger = LoggerFactory.getLogger((String)RingRequestField.class.getName());
    }
}

