/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.middleware;

import clojure.lang.Counted;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import com.appsflyer.donkey.server.ring.middleware.RingMiddleware;
import java.util.Iterator;
import java.util.Objects;

public class FormParamsKeywordizer
implements RingMiddleware {
    private static final Keyword FORM_PARAMS = Keyword.intern((String)"form-params");
    private final Options options;

    public FormParamsKeywordizer(Options options) {
        this.options = options;
    }

    @Override
    public IPersistentMap handle(IPersistentMap request) {
        Objects.requireNonNull(request, "Request map cannot be null");
        Object formParams = request.valAt((Object)FORM_PARAMS, null);
        if (formParams == null) {
            return request;
        }
        int size = ((Counted)formParams).count();
        if (size == 0) {
            return request;
        }
        return request.assoc((Object)FORM_PARAMS, (Object)this.keywordize((IPersistentMap)formParams));
    }

    private IPersistentMap keywordize(IPersistentMap map) {
        Object[] res = new Object[map.count() * 2];
        Iterator iter = map.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IMapEntry entry = (IMapEntry)iter.next();
            res[i] = Keyword.intern((String)((String)entry.getKey()));
            res[i + 1] = this.options.deep && entry.getValue() instanceof IPersistentMap ? this.keywordize((IPersistentMap)entry.getValue()) : entry.getValue();
            i += 2;
        }
        return RT.mapUniqueKeys((Object[])res);
    }

    public static class Options {
        private final boolean deep;

        public Options(boolean deep) {
            this.deep = deep;
        }
    }
}

