/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.route;

import com.appsflyer.donkey.server.route.HandlerMode;
import com.appsflyer.donkey.server.route.PathDefinition;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class RouteDefinition {
    private final Collection<HttpMethod> methods = EnumSet.noneOf(HttpMethod.class);
    private final Collection<String> consumes = new HashSet<String>(6);
    private final Collection<String> produces = new HashSet<String>(6);
    private HandlerMode handlerMode = HandlerMode.NON_BLOCKING;
    private Handler<RoutingContext> handler;
    private PathDefinition path;

    public static RouteDefinition create() {
        return new RouteDefinition();
    }

    private static void assertNonEmptyContentType(String val) {
        Objects.requireNonNull(val, "contentType cannot be null");
        if (val.isBlank()) {
            throw new IllegalArgumentException(String.format("Invalid content type: %s", val));
        }
    }

    private RouteDefinition() {
    }

    public PathDefinition path() {
        return this.path;
    }

    public RouteDefinition path(String path) {
        return this.path(PathDefinition.create(path));
    }

    public RouteDefinition path(PathDefinition path) {
        this.path = path;
        return this;
    }

    public Collection<HttpMethod> methods() {
        if (this.methods.isEmpty()) {
            return Collections.emptySet();
        }
        return Set.copyOf(this.methods);
    }

    public RouteDefinition addMethod(HttpMethod method) {
        Objects.requireNonNull(method, "method cannot be null");
        this.methods.add(method);
        return this;
    }

    public Collection<String> consumes() {
        if (this.consumes.isEmpty()) {
            return Collections.emptySet();
        }
        return Set.copyOf(this.consumes);
    }

    public RouteDefinition addConsumes(String contentType) {
        RouteDefinition.assertNonEmptyContentType(contentType);
        this.consumes.add(contentType);
        return this;
    }

    public Collection<String> produces() {
        if (this.produces.isEmpty()) {
            return Collections.emptySet();
        }
        return Set.copyOf(this.produces);
    }

    public RouteDefinition addProduces(String contentType) {
        RouteDefinition.assertNonEmptyContentType(contentType);
        this.produces.add(contentType);
        return this;
    }

    public Handler<RoutingContext> handler() {
        if (this.handler == null) {
            throw new IllegalStateException("No handlers were set");
        }
        return this.handler;
    }

    public RouteDefinition handler(Handler<RoutingContext> handler) {
        Objects.requireNonNull(handler, "Handler cannot be null");
        this.handler = handler;
        return this;
    }

    public HandlerMode handlerMode() {
        return this.handlerMode;
    }

    public RouteDefinition handlerMode(HandlerMode handlerMode) {
        Objects.requireNonNull(handlerMode, "handler mode cannot be null");
        this.handlerMode = handlerMode;
        return this;
    }
}

