/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.util;

import com.appsflyer.donkey.log.LogbackLogger;
import com.appsflyer.donkey.log.LogbackLoggerFactory;
import io.netty.util.ResourceLeakDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public final class DebugUtil {
    private static final String LOGBACK_LOGGER_FQCN = "ch.qos.logback.classic.Logger";
    private static final String LEAK_DETECTION_LEVEL = "io.netty.leakDetection.level";
    private static final AtomicBoolean logbackAvailabilityCheck = new AtomicBoolean();
    private static final AtomicBoolean logbackAvailable = new AtomicBoolean();
    private static final AtomicBoolean originalLevelsAvailable = new AtomicBoolean();
    private static final Map<String, String> originalLevels = new HashMap<String, String>(4);
    private static final String LEAK_DETECTOR_SIMPLE = ResourceLeakDetector.Level.SIMPLE.name().toLowerCase();
    private static final String LEAK_DETECTOR_DISABLED = ResourceLeakDetector.Level.DISABLED.name().toLowerCase();
    private static final String LOGGER_NETTY = "io.netty";
    private static final String LOGGER_VERTX = "io.vertx";
    private static final String LOGGER_APPSFLYER = "com.appsflyer";

    private DebugUtil() {
    }

    public static void enable() {
        DebugUtil.enableDebugLogging();
        System.setProperty(LEAK_DETECTION_LEVEL, LEAK_DETECTOR_SIMPLE);
    }

    public static void disable() {
        DebugUtil.disableDebugLogging();
        System.setProperty(LEAK_DETECTION_LEVEL, LEAK_DETECTOR_DISABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableDebugLogging() {
        DebugUtil.checkLogbackAvailability(DebugUtil::isLogbackAvailableWithWarning);
        if (!logbackAvailable.get()) {
            return;
        }
        LogbackLogger root = LogbackLoggerFactory.getLogger("ROOT");
        LogbackLogger vertx = LogbackLoggerFactory.getLogger(LOGGER_VERTX);
        LogbackLogger netty = LogbackLoggerFactory.getLogger(LOGGER_NETTY);
        LogbackLogger appsflyer = LogbackLoggerFactory.getLogger(LOGGER_APPSFLYER);
        if (!originalLevelsAvailable.get()) {
            Map<String, String> map = originalLevels;
            synchronized (map) {
                if (!originalLevelsAvailable.get()) {
                    originalLevels.put(root.getName(), root.getLevel());
                    originalLevels.put(vertx.getName(), vertx.getLevel());
                    originalLevels.put(netty.getName(), netty.getLevel());
                    originalLevels.put(appsflyer.getName(), appsflyer.getLevel());
                    originalLevelsAvailable.set(true);
                }
            }
        }
        root.setLevel("TRACE");
        vertx.setLevel("TRACE");
        netty.setLevel("TRACE");
        appsflyer.setLevel("TRACE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disableDebugLogging() {
        DebugUtil.checkLogbackAvailability(DebugUtil::isLogbackAvailable);
        if (!logbackAvailable.get()) {
            return;
        }
        LogbackLogger root = LogbackLoggerFactory.getLogger("ROOT");
        LogbackLogger vertx = LogbackLoggerFactory.getLogger(LOGGER_VERTX);
        LogbackLogger netty = LogbackLoggerFactory.getLogger(LOGGER_NETTY);
        LogbackLogger appsflyer = LogbackLoggerFactory.getLogger(LOGGER_APPSFLYER);
        if (originalLevelsAvailable.get()) {
            Map<String, String> map = originalLevels;
            synchronized (map) {
                if (originalLevelsAvailable.get()) {
                    root.setLevel(originalLevels.get(root.getName()));
                    vertx.setLevel(originalLevels.get(vertx.getName()));
                    netty.setLevel(originalLevels.get(netty.getName()));
                    appsflyer.setLevel(originalLevels.get(appsflyer.getName()));
                    originalLevels.clear();
                    originalLevelsAvailable.set(false);
                }
            }
        }
    }

    private static void checkLogbackAvailability(Supplier<Boolean> availabilityCheck) {
        if (!logbackAvailabilityCheck.get()) {
            if (availabilityCheck.get().booleanValue()) {
                logbackAvailable.set(true);
            }
            logbackAvailabilityCheck.set(true);
        }
    }

    private static boolean loadLogback() throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        loader.loadClass(LOGBACK_LOGGER_FQCN);
        return true;
    }

    private static boolean isLogbackAvailable() {
        try {
            return DebugUtil.loadLogback();
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static boolean isLogbackAvailableWithWarning() {
        try {
            return DebugUtil.loadLogback();
        }
        catch (ClassNotFoundException ex) {
            System.err.printf("%s - Warning! Did not find %s on classpath. Debug logging will be disabled.%n", DebugUtil.class.getCanonicalName(), LOGBACK_LOGGER_FQCN);
            return false;
        }
    }
}

