/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.client.ring;

import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.client.Client;
import com.appsflyer.donkey.client.ClientConfig;
import com.appsflyer.donkey.client.ring.RingRequestFactory;
import com.appsflyer.donkey.client.ring.RingResponseAdapter;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.multipart.MultipartForm;

public final class RingClient
implements Client<IPersistentMap, IPersistentMap> {
    private final WebClient client;
    private final RingRequestFactory requestFactory;

    public static RingClient create(ClientConfig config) {
        return new RingClient(config);
    }

    private RingClient(ClientConfig config) {
        this.client = WebClient.create((Vertx)config.vertx(), (WebClientOptions)config.clientOptions());
        this.requestFactory = RingRequestFactory.create(this.client);
    }

    @Override
    public HttpRequest<Buffer> request(IPersistentMap opts) {
        return this.requestFactory.create(opts);
    }

    @Override
    public Future<IPersistentMap> send(HttpRequest<Buffer> request) {
        Promise promise = Promise.promise();
        request.send((Handler)RingResponseAdapter.create((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public Future<IPersistentMap> send(HttpRequest<Buffer> request, Buffer body) {
        Promise promise = Promise.promise();
        request.sendBuffer(body, (Handler)RingResponseAdapter.create((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public Future<IPersistentMap> sendForm(HttpRequest<Buffer> request, MultiMap body) {
        Promise promise = Promise.promise();
        request.headers();
        request.sendForm(body, (Handler)RingResponseAdapter.create((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public Future<IPersistentMap> sendMultiPartForm(HttpRequest<Buffer> request, MultipartForm body) {
        Promise promise = Promise.promise();
        request.sendMultipartForm(body, (Handler)RingResponseAdapter.create((Promise<IPersistentMap>)promise));
        return promise.future();
    }

    @Override
    public void shutdown() {
        this.client.close();
    }
}

