/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)VertxFactory.class.getName());

    private VertxFactory() {
    }

    public static Vertx create(VertxOptions opts) {
        return Vertx.vertx((VertxOptions)opts).exceptionHandler(VertxFactory::defaultExceptionHandler);
    }

    private static void defaultExceptionHandler(Throwable ex) {
        Throwable t = ex;
        if (logger.isDebugEnabled()) {
            StackTraceElement[] stack = ex.getStackTrace();
            if (stack == null || stack.length == 0) {
                t = new RuntimeException(ex);
            }
            logger.debug(ex.getMessage(), t);
        } else {
            logger.error(ex.getMessage(), ex);
        }
    }
}

