/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.handler;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import com.appsflyer.donkey.server.ring.handler.RingHandler;
import com.appsflyer.donkey.server.ring.handler.RingResponseField;
import com.appsflyer.donkey.util.TypeConverter;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;

public final class RingResponseAdapter
implements RingHandler {
    public static RingHandler create() {
        return new RingResponseAdapter();
    }

    private RingResponseAdapter() {
    }

    public void handle(RoutingContext ctx) {
        IPersistentMap ringResponse = (IPersistentMap)ctx.get("RING_HANDLER_RESULT");
        if (ringResponse == null) {
            ctx.response().end();
            return;
        }
        HttpServerResponse serverResponse = ctx.response();
        this.addHeaders(serverResponse, ringResponse);
        this.setStatus(serverResponse, ringResponse);
        this.sendResponse(serverResponse, ringResponse);
    }

    private void addHeaders(HttpServerResponse serverResponse, IPersistentMap ringResponse) {
        IPersistentMap headers = (IPersistentMap)RingResponseField.HEADERS.from(ringResponse);
        if (headers != null) {
            for (Object obj : headers) {
                IMapEntry pair = (IMapEntry)obj;
                serverResponse.putHeader((CharSequence)pair.getKey(), (CharSequence)pair.getValue());
            }
        }
    }

    private void setStatus(HttpServerResponse serverResponse, IPersistentMap ringResponse) {
        serverResponse.setStatusCode(((Integer)RingResponseField.STATUS.from(ringResponse)).intValue());
    }

    private void sendResponse(HttpServerResponse serverResponse, IPersistentMap ringResponse) {
        serverResponse.end(TypeConverter.toBuffer(RingResponseField.BODY.from(ringResponse)));
    }
}

