/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.client;

import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.Objects;

public final class ClientConfig {
    private Vertx vertx;
    private WebClientOptions clientOptions;

    public static ClientConfigBuilder builder() {
        return new ClientConfigBuilder();
    }

    private ClientConfig() {
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public WebClientOptions clientOptions() {
        return this.clientOptions;
    }

    public static final class ClientConfigBuilder {
        private ClientConfig instance = new ClientConfig();

        private ClientConfigBuilder() {
        }

        public ClientConfigBuilder vertx(Vertx vertx) {
            Objects.requireNonNull(vertx, "Vertx argument cannot be null");
            this.instance.vertx = vertx;
            return this;
        }

        public ClientConfigBuilder clientOptions(WebClientOptions clientOptions) {
            Objects.requireNonNull(clientOptions, "Client options argument cannot be null");
            this.instance.clientOptions = clientOptions;
            return this;
        }

        public ClientConfig build() {
            this.assertValidState();
            ClientConfig res = this.instance;
            this.instance = null;
            return res;
        }

        private void assertValidState() {
            Objects.requireNonNull(this.instance.vertx, "Vertx field is missing");
            Objects.requireNonNull(this.instance.clientOptions, "Client options field is missing");
        }
    }
}

