/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.handler;

import java.time.Duration;
import java.util.Objects;

public class StaticResourcesConfig {
    private String resourcesRoot;
    private String indexPage;
    private boolean enableCaching;
    private Duration maxAge;
    private Duration localCacheDuration;
    private int localCacheSize;

    String resourcesRoot() {
        return this.resourcesRoot;
    }

    String indexPage() {
        return this.indexPage;
    }

    boolean enableCaching() {
        return this.enableCaching;
    }

    Duration maxAge() {
        return this.maxAge;
    }

    Duration localCacheDuration() {
        return this.localCacheDuration;
    }

    int localCacheSize() {
        return this.localCacheSize;
    }

    public static class Builder {
        private static final char ROOT_CHAR = '/';
        private StaticResourcesConfig instance = new StaticResourcesConfig();

        private static String ensureLeadingSlash(String path) {
            if (path.charAt(0) != '/') {
                return "/" + path;
            }
            return path;
        }

        public Builder resourcesRoot(String resourcesRoot) {
            Objects.requireNonNull(resourcesRoot, "resourcesRoot cannot be null");
            if (resourcesRoot.isEmpty()) {
                throw new IllegalArgumentException("resourcesRoot cannot be empty");
            }
            this.instance.resourcesRoot = resourcesRoot;
            return this;
        }

        public Builder indexPage(String indexPage) {
            Objects.requireNonNull(indexPage, "indexPage cannot be null");
            if (indexPage.isEmpty()) {
                throw new IllegalArgumentException("indexPage cannot be empty");
            }
            this.instance.indexPage = Builder.ensureLeadingSlash(indexPage);
            return this;
        }

        public Builder enableCaching(boolean enable) {
            this.instance.enableCaching = enable;
            return this;
        }

        public Builder localCacheDuration(Duration duration) {
            Objects.requireNonNull(duration, "localCacheDuration cannot be null");
            this.instance.localCacheDuration = duration;
            return this;
        }

        public Builder maxAge(Duration duration) {
            Objects.requireNonNull(duration, "max-age duration cannot be null");
            this.instance.maxAge = duration;
            return this;
        }

        public Builder localCacheSize(int size) {
            if (size < 1) {
                throw new IllegalArgumentException("local cache size must be greater than 0");
            }
            this.instance.localCacheSize = size;
            return this;
        }

        public StaticResourcesConfig build() {
            StaticResourcesConfig res = this.instance;
            this.instance = null;
            return res;
        }
    }
}

