/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.handler;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import com.appsflyer.donkey.server.handler.ErrorHandler;
import com.appsflyer.donkey.server.ring.handler.RingAdapterFactory;
import com.appsflyer.donkey.server.ring.handler.RingResponseField;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class RingErrorHandler
implements ErrorHandler<IFn> {
    private static final Keyword PATH = Keyword.intern((String)"path");
    private static final Keyword CAUSE = Keyword.intern((String)"cause");
    private static final Keyword STATUS = RingResponseField.STATUS.keyword();
    private final Handler<RoutingContext> responseAdapter;
    private final Map<Integer, Handler<RoutingContext>> handlers = new HashMap<Integer, Handler<RoutingContext>>();

    public static RingErrorHandler create() {
        return new RingErrorHandler();
    }

    private RingErrorHandler() {
        this.responseAdapter = RingAdapterFactory.create().responseAdapter();
    }

    public RingErrorHandler add(int statusCode, IFn handler) {
        this.handlers.put(statusCode, (Handler<RoutingContext>)((Handler)ctx -> {
            IPersistentMap response = (IPersistentMap)handler.invoke((Object)this.payload((RoutingContext)ctx));
            if (!response.containsKey((Object)STATUS)) {
                response = response.assoc((Object)STATUS, (Object)statusCode);
            }
            ctx.put("RING_HANDLER_RESULT", (Object)response);
            this.responseAdapter.handle(ctx);
        }));
        return this;
    }

    @Override
    public void forEach(BiConsumer<Integer, Handler<RoutingContext>> consumer) {
        this.handlers.forEach(consumer);
    }

    private IPersistentMap payload(RoutingContext ctx) {
        IPersistentMap payload = RT.map((Object[])new Object[]{PATH, ctx.normalizedPath()});
        if (ctx.failure() != null) {
            payload = payload.assoc((Object)CAUSE, (Object)ctx.failure());
        }
        return payload;
    }
}

