/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.donkey.server.ring.handler;

import com.appsflyer.donkey.server.ring.handler.RingHandler;
import com.appsflyer.donkey.server.ring.handler.RingRequestField;
import com.appsflyer.donkey.util.TypeConverter;
import io.vertx.ext.web.RoutingContext;

public final class RingRequestAdapter
implements RingHandler {
    public static RingHandler create() {
        return new RingRequestAdapter();
    }

    private RingRequestAdapter() {
    }

    public void handle(RoutingContext ctx) {
        RingRequestField[] fields = RingRequestField.values();
        Object[] values = new Object[fields.length * 2];
        int valueIndex = 0;
        for (int i = 0; i < fields.length; ++i) {
            RingRequestField field = fields[i];
            Object v = field.from(ctx);
            if (v == null) continue;
            values[valueIndex] = field.keyword();
            values[valueIndex + 1] = v;
            valueIndex += 2;
        }
        if (valueIndex == values.length) {
            ctx.put("RING_HANDLER_RESULT", (Object)TypeConverter.toPersistentMap(values));
        } else {
            Object[] copy = new Object[valueIndex];
            System.arraycopy(values, 0, copy, 0, valueIndex);
            ctx.put("RING_HANDLER_RESULT", (Object)TypeConverter.toPersistentMap(copy));
        }
        ctx.next();
    }
}

