/*
 * Decompiled with CFR 0.152.
 */
package com.ashafa;

import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.Keyword;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import com.ashafa.clutchapp$clone;
import com.ashafa.clutchapp$clone_all;
import com.ashafa.clutchapp$clone_all_dbs;
import com.ashafa.clutchapp$load_all_ddocs;
import com.ashafa.clutchapp$load_design_doc;
import com.ashafa.clutchapp$load_files;
import com.ashafa.clutchapp$load_view;
import com.ashafa.clutchapp$load_views;
import com.ashafa.clutchapp$loading__4410__auto__;
import com.ashafa.clutchapp$push;
import com.ashafa.clutchapp$push_all;
import com.ashafa.clutchapp$write_view;
import java.util.Arrays;

public class clutchapp__init {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"ns");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"in-ns");
    public static final AFn const__2 = (AFn)((IObj)Symbol.create(null, (String)"com.ashafa.clutchapp")).withMeta(RT.map((Object[])new Object[]{Keyword.intern((Symbol)Symbol.create(null, (String)"author")), "Chas Emerick", Keyword.intern((Symbol)Symbol.create(null, (String)"doc")), "This is a spike of a couchapp-compatible design document sync tool\n          built on clutch. The objectives here are much less ambitious and\n          not necessarily the same as couchapp's.\n\n          Specifically, these utilities only support pushing and cloning\n          design documents as a way of initializing databases and views as\n          required by applications using a couchdb instance as a data source.\n          i.e. enabling clojure webapps to carry view definitions and\n          prep a couch for use itself automagically rather than having a separate\n          db configuration/preparation stage prior to app deployment.\n\n          Some notes:\n\n          * only _id, language, and views slots are copied in either direction\n          * clone-all and push-all are available for operating over all design\n            documents in a database/directory; the former will create the target\n            database if necessary."}));
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"with-loading-context");
    public static final Var const__4 = RT.var((String)"clojure.core", (String)"fn");
    public static final Var const__5 = RT.var((String)"com.ashafa.clutchapp", (String)"+language->ext+");
    public static final Keyword const__6 = Keyword.intern((Symbol)Symbol.create(null, (String)"file"));
    public static final Keyword const__7 = Keyword.intern((Symbol)Symbol.create(null, (String)"line"));
    public static final Object const__8 = 52;
    public static final Var const__9 = RT.var((String)"clojure.core", (String)"declare");
    public static final Var const__10 = RT.var((String)"com.ashafa.clutchapp", (String)"*lang-ext*");
    public static final Object const__11 = 57;
    public static final Keyword const__12 = Keyword.intern((Symbol)Symbol.create(null, (String)"declared"));
    public static final Var const__13 = RT.var((String)"com.ashafa.clutchapp", (String)"*push-overwrite?*");
    public static final Object const__14 = 59;
    public static final Keyword const__15 = Keyword.intern((Symbol)Symbol.create(null, (String)"doc"));
    public static final Var const__16 = RT.var((String)"clojure.core", (String)"defn-");
    public static final Var const__17 = RT.var((String)"clojure.core", (String)"defn");
    public static final Var const__18 = RT.var((String)"com.ashafa.clutchapp", (String)"load-files");
    public static final Object const__19 = 64;
    public static final Keyword const__20 = Keyword.intern((Symbol)Symbol.create(null, (String)"arglists"));
    public static final Object const__21 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"dir"), Symbol.create(null, (String)"paths")})));
    public static final Keyword const__22 = Keyword.intern((Symbol)Symbol.create(null, (String)"private"));
    public static final Var const__23 = RT.var((String)"com.ashafa.clutchapp", (String)"load-view");
    public static final Object const__24 = 76;
    public static final Object const__25 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"view-dir")})));
    public static final Var const__26 = RT.var((String)"com.ashafa.clutchapp", (String)"load-views");
    public static final Object const__27 = 88;
    public static final Object const__28 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"design-doc-path")})));
    public static final Var const__29 = RT.var((String)"com.ashafa.clutchapp", (String)"load-design-doc");
    public static final Object const__30 = 97;
    public static final Object const__31 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"design-doc-path")})));
    public static final Var const__32 = RT.var((String)"com.ashafa.clutchapp", (String)"load-all-ddocs");
    public static final Object const__33 = 112;
    public static final Object const__34 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"dir-or-ddocs")})));
    public static final Var const__35 = RT.var((String)"com.ashafa.clutchapp", (String)"push");
    public static final Object const__36 = 135;
    public static final Object const__37 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"design-doc"), Symbol.create(null, (String)"db-url")})));
    public static final Var const__38 = RT.var((String)"com.ashafa.clutchapp", (String)"push-all");
    public static final Object const__39 = 159;
    public static final Object const__40 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"dir-or-ddocs"), Symbol.create(null, (String)"db-url")})));
    public static final Var const__41 = RT.var((String)"com.ashafa.clutchapp", (String)"write-view");
    public static final Object const__42 = 171;
    public static final Object const__43 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"views-dir"), RT.vector((Object[])new Object[]{Symbol.create(null, (String)"vname"), Symbol.create(null, (String)"fns")})})));
    public static final Var const__44 = RT.var((String)"com.ashafa.clutchapp", (String)"clone");
    public static final Object const__45 = 179;
    public static final Object const__46 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"design-doc-url"), Symbol.create(null, (String)"dest-path")})));
    public static final Var const__47 = RT.var((String)"com.ashafa.clutchapp", (String)"clone-all");
    public static final Object const__48 = 197;
    public static final Object const__49 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"db-url"), Symbol.create(null, (String)"dest-path")})));
    public static final Var const__50 = RT.var((String)"com.ashafa.clutchapp", (String)"clone-all-dbs");
    public static final Object const__51 = 212;
    public static final Object const__52 = PersistentList.create(Arrays.asList(RT.vector((Object[])new Object[]{Symbol.create(null, (String)"couch-url"), Symbol.create(null, (String)"dest-path")})));

    public static void load() {
        Object object = ((IFn)const__1.get()).invoke((Object)const__2);
        Object object2 = ((IFn)new clutchapp$loading__4410__auto__(null)).invoke();
        Var var = const__5;
        var.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__8}));
        Var var2 = var;
        var.bindRoot((Object)RT.map((Object[])new Object[]{"javascript", "js", "clojure", "clj", "python", "py", "ruby", "rb"}));
        Var var3 = const__10;
        Var var4 = const__13;
        var4.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__14, const__15, "Bindable var to control whether design documents are overwritten\n              when pushing. If false (it's true by default), and a design document\n              already exists, the push fns will become no-ops (logging that fact)."}));
        Var var5 = var4;
        var4.bindRoot((Object)Boolean.TRUE);
        Var var6 = const__18;
        var6.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__19, const__20, const__21, const__15, "Loads the files within the directory named by the paths,\n   returning a seq of [:filename content] vectors.  Note that file\n   extensions are trimmed in the process of creating :filename.", const__22, Boolean.TRUE}));
        Var var7 = var6;
        var6.bindRoot((Object)((IObj)new clutchapp$load_files(null)).withMeta(((AReference)const__18).meta()));
        Var var8 = const__23;
        var8.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__24, const__20, const__25, const__15, "Loads a view from a view directory, returning a map of\n   {:view-name {:map \"<some js>\" :reduce \"<some js>\"}},\n   with map and reduce content coming from map.js and reduce.js\n   files in the view dir.\n\n   @todo add support for other languages based on the design doc's\n   :language slot, e.g. map.clj, reduce.clj", const__22, Boolean.TRUE}));
        Var var9 = var8;
        var8.bindRoot((Object)((IObj)new clutchapp$load_view(null)).withMeta(((AReference)const__23).meta()));
        Var var10 = const__26;
        var10.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__27, const__20, const__28, const__15, "Loads all views under the given design document root directory path.", const__22, Boolean.TRUE}));
        Var var11 = var10;
        var10.bindRoot((Object)((IObj)new clutchapp$load_views(null)).withMeta(((AReference)const__26).meta()));
        Var var12 = const__29;
        var12.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__30, const__20, const__31, const__15, "Loads the design document rooted at the given directory. The value of the :_id\n   slot in the returned map will be the contents of the _id file in the directory,\n   *not* _design/<directory name>. Throws an IllegalStateException if either _id or\n   language files are not found in that directory.", const__22, Boolean.TRUE}));
        Var var13 = var12;
        var12.bindRoot((Object)((IObj)new clutchapp$load_design_doc(null)).withMeta(((AReference)const__29).meta()));
        Var var14 = const__32;
        var14.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__33, const__20, const__34, const__15, "Utility fn used by push-all for loading a set of design documents rooted\n   in a provided directory (or, returns a sequential arg untouched).\n\n   This is also helpful in a webapp build process for bundling up the design\n   documents associated with the webapp into a single json file that can be\n   used to ramp up the app's couchdb instance at webapp init time.  e.g.:\n\n   Build-time: (-> \"some file path\" load-all-ddocs pr),\n         and push the result into your war file\n   Runtime: (-> \"war rsrc path\" slurp* read (push-all \"http://dbhost:5984/dbname\"))\n   "}));
        Var var15 = var14;
        var14.bindRoot((Object)((IObj)new clutchapp$load_all_ddocs(null)).withMeta(((AReference)const__32).meta()));
        Var var16 = const__35;
        var16.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__36, const__20, const__37, const__15, "Pushes a single design document, to the database specified by the URL.\n   The design document argument can be a string or a map: if the former,\n   the design document will be loaded from the directory path specified by\n   that string; if the latter, the map will be used directly as the\n   design document.\n\n   The database must exist, or an IllegalStateException will be thrown."}));
        Var var17 = var16;
        var16.bindRoot((Object)((IObj)new clutchapp$push(null)).withMeta(((AReference)const__35).meta()));
        Var var18 = const__38;
        var18.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__39, const__20, const__40, const__15, "Pushes all design documents within the provided directory or already-loaded\n   seq of design document maps to the database\n   specified by the URL.  If the database does not exist, it will be created."}));
        Var var19 = var18;
        var18.bindRoot((Object)((IObj)new clutchapp$push_all(null)).withMeta(((AReference)const__38).meta()));
        Var var20 = const__41;
        var20.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__42, const__20, const__43, const__22, Boolean.TRUE}));
        Var var21 = var20;
        var20.bindRoot((Object)((IObj)new clutchapp$write_view(null)).withMeta(((AReference)const__41).meta()));
        Var var22 = const__44;
        var22.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__45, const__20, const__46, const__15, "Clones the design document at the provided URL to the specified\n   destination directory path.  This operation clobbers any existing\n   content in the destination directory."}));
        Var var23 = var22;
        var22.bindRoot((Object)((IObj)new clutchapp$clone(null)).withMeta(((AReference)const__44).meta()));
        Var var24 = const__47;
        var24.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__48, const__20, const__49, const__15, "Clones all of the design documents in the database rooted at the\n   provided URL to a set of directories in the specified destination\n   directory path.  This operation clobbers any existing\n   content in the destination directory."}));
        Var var25 = var24;
        var24.bindRoot((Object)((IObj)new clutchapp$clone_all(null)).withMeta(((AReference)const__47).meta()));
        Var var26 = const__50;
        var26.setMeta(RT.map((Object[])new Object[]{const__6, "com/ashafa/clutchapp.clj", const__7, const__51, const__20, const__52, const__15, "Clones all design documents from all databases at the couchdb instance\n   specified by the URL to the destination path provided. This operation\n   clobbers any existing content in the destination directory."}));
        Var var27 = var26;
        var26.bindRoot((Object)((IObj)new clutchapp$clone_all_dbs(null)).withMeta(((AReference)const__50).meta()));
    }

    static {
        Compiler.pushNS();
        try {
            clutchapp__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

