(ns user)

(def bilbo (ref {:hp 500 :energy 100 :name "Bilbo"}))

(def gandalf (ref {:hp 250 :mana 100 :name "Gandalf"}))

(def smaug (ref {:hp 1000 :energy 200 :name "Smaug"}))

;(defn positive-mana)

(defn heal
  [healer other]
  (dosync
    (when (< (:mana @healer) 10)
      (throw (IllegalStateException. (str (:name @healer) " is out of mana, cannot heal"))))
    (let [healp (* (:mana @healer) (rand))]
      (alter other update-in [:hp] + healp)
      (alter healer update-in [:mana] - (max 1 (/ healp 10))))))