(ns atomist.cljs-log
  (:require [goog.string :as gstring]
            [goog.string.format]
            [cljs.pprint]
            ["@atomist/skill-logging/lib/logging" :as skill-logging]))

(def logger js/console)
(def atomist-logger)

(defn create-logger [correlation-id event-id]
  (let [skill-logger ((. skill-logging -createLogger) #js {:correlationId correlation-id
                                                           :eventId event-id})]
    (set! atomist-logger skill-logger)))

(comment
 (create-logger "correlation-id" "event-id"))

(defn atomist-log [s k]
  (.catch
   (.then
    (.log atomist-logger s (case k
                             :info (.. skill-logging -Severity -INFO)
                             :warning (.. skill-logging -Severity -WARNING)
                             :error (.. skill-logging -Severity -ERROR)))
    (fn [v]))
   (fn [error] (.error js/console error))))

(defn- log [& args]
  (if atomist-logger
    (atomist-log (apply str args) :info)
    (.info logger (apply str args))))

(defn warn [& args]
  (if atomist-logger
    (atomist-log (apply str args) :warning)
    (.warn logger (apply str args))))

(def info log)

(defn error [& args]
  (if atomist-logger
    (atomist-log (apply str args) :error)
    (.error logger (apply str args))))

(defn debug [& args]
  (.debug logger (apply str args)))

(defn infof [s & args]
  (info (apply gstring/format s args)))

(defn warnf [s & args]
  (warn (apply gstring/format s args)))

(defn errorf [ex s & args]
  (error (.-message ex))
  (error (apply gstring/format s args)))

(defn ptrace [x]
  (log (with-out-str (cljs.pprint/pprint x)))
  x)
