(ns atomist.slack
  (:require
   [goog.string :as gstring]
   [goog.string.format]))

(defn github-auth-blocks [ch-request provider-id]
  {"blocks" [{
              "type" "section",
              "text" {
                      "type" "mrkdwn",
                      "text" (gstring/format "Hi %s :wave:" (-> ch-request :source :slack :user :name))
                      }
              },
             {
              "type" "section",
              "text" {
                      "type" "mrkdwn",
                      "text" "Great to see you here! You can use Atomist to link your GitHub identity to your Slack identity.  Atomist GitHub skills executed from Slack will run using your GitHub account.  Examples of GitHub skills that ship with Atomist:"
                      }
              },
             {
              "type" "section",
              "text" {
                      "type" "mrkdwn",
                      "text" "• create Issues \n • generate new Repositories \n • add Slack conversations to Issues"
                      }
              },
             {
              "type" "section",
              "text" {
                      "type" "mrkdwn",
                      "text" "But before you can do all these amazing things, we need you to connect your Slack Identity to your GitHub identity. Simply click the button below:"
                      }
              },
             {
              "type" "section",
              "text" {
                      "type" "mrkdwn",
                      "text" (str
                              (gstring/format
                               "<https://api.atomist.com/v2/auth/teams/%s/resource-providers/%s/token?state=%s&redirect-uri=https://www.atomist.com/success.html|link github user>"
                               (-> ch-request :team :id)
                               provider-id
                               (str (random-uuid)))
                              " or use `@atomist authorize github`")
                      },
              "accessory" {
                           "type" "image",
                           "image_url" "https://pngimg.com/uploads/github/github_PNG40.png",
                           "alt_text" "GitHub"
                           }
              }]})