(ns atomist.repo-filter
  (:require [atomist.cljs-log :as log]))

(defn includes?
  "
    coll of {:keys [ownerId repoIds providerId]}"
  [coll {:keys [repo-id owner-id]}]
  (some (fn [pattern] (and
                       (= owner-id (:ownerId pattern))
                       (if (not (empty? (:repoIds pattern)))
                         (some #(= repo-id %) (:repoIds pattern))
                         true))) coll))

(defn ref-matches-repo-filter? [request {:keys [repo-id owner-id] :as ref} {:keys [includes excludes]}]
  (if (not repo-id)
    (do
      (log/warnf "repo-id is null for ref %s" ref)
      false)
    (if (not owner-id)
      (do
        (log/warnf "owner-id is null for ref %s" ref)
        false)
      (and
       (includes? includes ref)
       (not (includes? excludes ref))))))

