(ns atomist.time
  (:require [cljs-time.core :as t]
            [cljs-time.format :as tf]
            [cljs-time.coerce :as tc]))

(defn now [] (tc/to-long (t/now)))

(defn week-date-time-no-ms [tc]
  (tf/unparse (tf/formatters :week-date-time-no-ms) tc))

(defn year-month-day [tc]
  (tf/unparse (tf/formatters :year-month-day) tc))

(defn week-date-time-no-ms-now []
  (week-date-time-no-ms (t/now)))

(def utc (t/to-utc-time-zone (t/now)))

(defn hour [tz]
  (t/hour
   (case (-> tz :offset first)
     :+ (t/plus (t/to-utc-time-zone (t/now)) (t/hours (-> tz :offset second)))
     :- (t/minus (t/to-utc-time-zone (t/now)) (t/hours (-> tz :offset second))))))
