(ns atomist.cljs-log
  (:require [goog.string :as gstring]
            [goog.string.format]
            [cljs.pprint]
            ["@atomist/skill-logging/lib/logging" :as skill-logging]))

(def logger js/console)
(def atomist-logger)

(defn create-logger [correlation-id event-id workspace-id]
  (let [skill-logger ((. skill-logging -createLogger) #js {:correlationId correlation-id
                                                           :eventId event-id
                                                           :workspaceId workspace-id})]
    (set! atomist-logger skill-logger)))

(defn atomist-log [s k]
  (.catch
   (.then
    (.log atomist-logger s (case k
                             :info (.. skill-logging -Severity -INFO)
                             :warning (.. skill-logging -Severity -WARNING)
                             :error (.. skill-logging -Severity -ERROR)))
    (fn [v]))
   (fn [error]
     (.error js/console (gstring/format "error logging:  %s" error)))))

(defn- log [& args]
  (.info logger (apply str args))
  (if atomist-logger
    (atomist-log (apply str args) :info)))

(defn warn [& args]
  (.warn logger (apply str args))
  (if atomist-logger
    (atomist-log (apply str args) :warning)))

(def info log)

(defn error [& args]
  (.error logger (apply str args))
  (if atomist-logger
    (atomist-log (apply str args) :error)))

(defn debug [& args]
  (.info logger (apply str args)))

(defn infof [s & args]
  (info (apply gstring/format s (map #(or % nil) args))))

(defn warnf [s & args]
  (warn (apply gstring/format s (map #(or % nil) args))))

(defn debugf [s & args]
  (debug (apply gstring/format s (map #(or % nil) args))))

(defn errorf [ex s & args]
  (error (.-message ex))
  (error (apply gstring/format s (map #(or % nil) args))))

(defn ptrace [x]
  (log (with-out-str (cljs.pprint/pprint x)))
  x)
