(ns atomist.graphql)

(def head-commits
  "query headCommits($type: String!, $name: String!) {
     headCommitsWithFingerprint(type: $type, name: $name) {
       analysis {
         type
         name
         sha
         data
         id
       }
       branch {
         id
         name
       }
       repo @required {
         id
         name
         owner
       }
     }
  }")

(def delete-fingerprint-type
  "mutation deleteType($type: String!) {
     deleteFingerprints(type: $type)
   }")

(def linkedScmId
  "query linkedScmId ($chatUserId: String!) {
     ChatId(userId: $chatUserId) {
        person {
                scmId {
                       provider {
                                 providerId
                                 providerType
                                 }
                       login
                       emails {
                          address
                       }
                       credential {
                                   secret
                                   }
                       }
                }
        }
     }")

(def chatTeam
  "query chatTeams($id: String!) {
     Team(id: $id) {
       chatTeams {
         id
         name
       }
     }
  }")

(def linkedRepos
  "query linkedRepos ($channelId: String!) {
    ChatChannel(channelId: $channelId) {
       repos {
              id
              name
              org {
                   owner
                   id
                   scmProvider {
                                providerId
                                providerType
                                }
                   }
              }
       }
    }")

(def scmProviders
  "query {SCMProvider {id providerId providerType}}")

(def githubAppInstallationByOwner
  "query GitHubAppInstallationByOwner($name: String!) {
      GitHubAppInstallation(owner: $name) {
        token {
          secret
        }
      }
  }")

(def setTarget
  "mutation setTarget($name: String!, $sha: String!, $type: String!) {
     setFingerprintTarget(target: {name: $name, sha: $sha, type: $type}) {
       fingerprint {
         id}}}")

(def repo
  "query repo ($name: String!) {
      Repo(name: $name) {
                         id
                         defaultBranch
                         org {
                              id
                              owner
                              scmProvider {
                                           providerId
                                           credential {
                                                       secret
                                                       }
                                           }
                              }
                         }
      }")

(def repos
  "query repos {
     Org {
       id
       owner
       repos {
         id
         name
       }
       scmProvider {
         providerId
         id
         credential {
           secret
         }
       }
     }
  }")

(def send-fingerprints
  "mutation AddFingerprints(
     $type: String!,
     $additions: [FingerprintInput!]!,
     $branchId: String!,
     $sha: String!,
     $repoId: String!,
     $isDefaultBranch: Boolean!)
     {setCommitFingerprints (
       add: $additions,
       isDefaultBranch: $isDefaultBranch,
       isHeadCommit: true,
       type: $type,
       branchId: $branchId,
       commitSha: $sha,
       repoId: $repoId,
     )
   }")

(def repo-branch-ids
  "query RepoBranchIds(
     $owner: String!,
     $repo: String!,
     $branch: String!)
   {
     Repo(
        name: $repo,
        owner: $owner)
     {
        id
        defaultBranch
        branches(name: $branch)
        {
          id
        }
     }
   }")

(def fingerprint-targets
  "query fingerprintTargets($type: String!) {
     fingerprintTargets(type: $type) {
       fingerprint {
         data
         name
         type
         sha
         displayName
         displayType
         displayValue
       }
     }
   }")

(def query-latest-semver
  "query semver ($type: String!, $name: String!) {
     fingerprintAggregates(type: $type, name: $name) {
       latestSemVerUsed {
         inRepos
         fingerprint {
           displayValue
           name
           sha
           data
         }
       }
       latestSemVerAvailable {
         displayValue
         name
         sha
         data
       }
     }
  }")
