(ns atomist.topics
  (:require ["@google-cloud/pubsub" :as pubsub]
            [atomist.cljs-log :as log]))

(def PubSub (new (. pubsub -PubSub)))

(defn sendreponse [topic-name obj]
  (let [topic (.topic PubSub topic-name)
        message-buffer (.from js/Buffer (js/JSON.stringify obj) "utf8")]
    (.catch
     (.then
      (.publish topic message-buffer)
      (fn [result]
        (log/debugf "published to %s:  %s" topic-name result)))
     (fn [error]
       (log/errorf "error publishing to %s:  %s" topic-name error)))))