(ns atomist.async
  (:require
   [clojure.core.async :as a])
  (:require-macros [atomist.async]))

(defn throw-err "Throw if is error, will be different in ClojureScript"
  [v]
  (if (instance? js/Error v) (throw v) v))

(defn map-reduce
  "Map async function f over coll and return a channel containing a vector of results of each call to f"
  [f coll]
  (atomist.async/go-safe
   (atomist.async/<? (->> coll
                          (map f)
                          (a/merge)
                          (a/reduce conj [])))))