(ns atomist.async
  (:require [cljs.core.async :as a :refer-macros [go]]))

(defmacro <? "Version of <! that throw Exceptions that come out of a channel."
  [c]
  `(atomist.async/throw-err (cljs.core.async/<! ~c)))

(defmacro err-or "If body throws an exception, catch it and return it"
  [& body]
  `(try
     ~@body
     (catch :default e#
       e#)))

(defmacro go-safe [& body]
  `(cljs.core.async/go (err-or ~@body)))

