(ns atomist.api.v2.log
  (:require [atomist.api.v2 :as v2]
            [atomist.time :as time]
            [goog.string :refer [format]] 
            [goog.string.format]))

;; TODO this only works if the trigger can be a global binding and we're not processing concurrent requests
(def trigger)
(defn set-trigger [r]
  (set! trigger r))

(defn log [level s]
  (v2/execution-logs
   trigger [{:text s
             :timestamp (time/now-iso-8601)
             :level level}]))

(defn infof [f & args]
  (println (apply format f args)))
(defn debugf [f & args]
  (println (apply format f args)))
(defn warn [& args]
  (apply println args))
(defn info [& args]
  (apply println args))
