(ns atomist.slack.attachment-messages
  (:require [com.rpl.specter :as specter]))

(defn add-ids-to-commands
  "attachment style messages only - try to use block messages instead"
  [slack message-id]
  (let [num (atom 0)]
    (specter/transform [:attachments specter/ALL :actions specter/ALL]
                       #(if (:atomist/command %)
                          (-> %
                              (assoc-in [:atomist/command :id]
                                        (str (get-in % [:atomist/command :command])
                                             "-"
                                             (swap! num inc)))
                              (update-in [:atomist/command :parameters] (fnil conj []) {:name "messageId" :value message-id})
                              (assoc-in [:atomist/command :automation]
                                        {:name "@atomisthq/stupendabot-command-handler-cljs"
                                         :version "0.1.9"}))
                          %)
                       slack)))

(defn transform-to-slack-actions
  "attachment style slack message only - try to use block messages instead"
  [slack]
  (specter/transform [:attachments specter/ALL :actions specter/ALL]
                     #(if (:atomist/command %)
                        (let [action-id (get-in % [:atomist/command :id])]
                          (case (:type %)
                            "button"
                            (-> %
                                (dissoc :atomist/command)
                                (assoc :name (str "automation-command::" action-id))
                                (assoc :value action-id))
                            "select"
                            (-> %
                                (dissoc :atomist/command)
                                (assoc :name (str "automation-command::" action-id)))
                            %))
                        %)
                     slack))
