(ns atomist.graphql
  (:require [clj-http.client :as client]
            [atomist.json :as json]
            [clojure.java.io :as io]))

(defn run-query
  "An automation can run queries on an open-ended set of teams (it can be registered to multiple teams.
     params
       team-id  - Atomist workspace id
       query    - string graphql query
     returns nil for errors or the body of the query response"
  ([request query variables]
   (let [response
         (client/post
          (format "%s/team/%s" (:graphql-endpoint request) (:team-id request))
          {:body (json/->str {:query query :variables variables})
           :headers {:authorization (format "Bearer %s" (:api-key request))}
           :throw-exceptions false})]
     (if (and
          (not (-> response :body json/->obj :errors))
          (= 200 (:status response)))
       (-> response :body (json/->obj))
       (throw (ex-info
               (format "failure to run query %s\n%s" query response)
               {:query query
                :response response})))))
  ([request query]
   (run-query request query {})))

(defn register-skill []
  (slurp (io/resource "graphql/mutation/registerSkill.graphql")))

(defn get-branches-for-repo []
  (slurp (io/resource "graphql/query/GetBranchIdForRepo.graphql")))
