(ns atomist.json
  (:require [cheshire.core :as cheshire]
            [cheshire.generate :as ch-generate]
            [clojure.java.io :as io])
  (:import (com.fasterxml.jackson.core JsonParseException)
           (java.io Reader InputStream)))

(defn add-encoder!
  [cls encoder]
  (ch-generate/add-encoder cls encoder))

(defn remove-encoder!
  [clj]
  (ch-generate/remove-encoder clj))

(defn ->str
  ([o]
   (->str o false))
  ([o pretty?]
   (when o
     (cheshire/generate-string o {:pretty pretty?}))))

(defn ->obj
  "Convert string or read. We get a lazy seq back if a reader was passed"
  [jsony]
  (when jsony
    (try
      (cond
        (string? jsony) (cheshire/parse-string jsony keyword)
        (instance? Reader jsony) (cheshire/parse-stream jsony keyword)
        (instance? InputStream jsony) (cheshire/parse-stream (io/reader jsony) keyword)
        :else
        (throw (IllegalArgumentException. (format "Unknown JSON input type %s" (.getName ^Class (type jsony))))))
      (catch JsonParseException e
        (throw (IllegalArgumentException. e))))))