(ns com.avisi-apps.gaps.rollbar.core
  (:require
    [com.avisi-apps.gaps.rollbar.api :as api]
    [cljs-bean.core :refer [->js]]))

(defn BuildFramesForException [payload]
  (js/console.log "payload")
  (js/console.log payload)
  (js/console.log "->js payload")
  (js/console.log (->js payload))

  (js/console.log ())

  (let [frames [{:filename (get-in payload [:sourceLocation :file])
                :lineno (get-in payload [:sourceLocation :line])
                :class_name (get-in payload [:sourceLocation :ns])}]]
    (js/console.log "frames :")
    (js/console.log frames)
    frames))

(defn logAdditionalInformation [severity message payload]
    (if (compare severity "ERROR")
      (api/sendExceptionToRollbar severity message payload (BuildFramesForException payload))
      (api/sendMessageToRollbar severity message)))
