(ns com.avisi-apps.gaps.appenders.timbre.rollbar)

(defn ^:private log! [^js rollbar level msg err ns]
  (case level
    :trace (.debug rollbar msg {:namespace ns})
    :debug (.debug rollbar msg {:namespace ns})
    :info (.info rollbar msg {:namespace ns})
    :warn (.warning rollbar msg {:namespace ns})
    :error (.error rollbar msg err {:namespace ns})
    :fatal (.critical rollbar msg {:namespace ns})
    :report (.info rollbar msg {:namespace ns})))

(defn rollbar-appender
  "Returns a timbre Rollbar appender

  Requires a Rollbar client to be passed in,
  see Rollbar (Browser JS/Node.js) documentation for details.

  Options:
    * :ns-filter-fn checks the namespace to determine if it should be sent.
      By default `identity` so everything is sent through.
    * :context sets the Rollbar context in the payload"
  ([^js rollbar] (rollbar-appender rollbar {}))
  ([^js rollbar opts]
   (let [{:keys [ns-filter-fn context]
          :or {ns-filter-fn identity}} opts]
     {:enabled? true
      :async? true
      :min-level :error ;; Sane default for Rollbar
      :fn
      (fn [{:keys [level msg_ ?ns-str ?err]}]
        (when (and rollbar (ns-filter-fn ?ns-str))
          (when context
            (.configure ^js rollbar #js {:payload #js {:context context}}))

          (log! rollbar level (force msg_) ?err ?ns-str)))})))
