# 2. Handling additional logging service data

Date: 06-01-2023

## Status

Accepted

## Context

In order te pass all the information needed for the Rollbar external logging service, we need to find a good solution to implement this in the existing code.

The solution decided on in this decision will affect the call all the projects that implement the logging library. 
It wil also infect the inner structure of the logging project.

Currently, the way a project uses the log function before implementing the additional date in order to send a debug log message:

```Clojure
(log/debug {:message "this is an example"})
```
We will modify this call in every option in order to create a better insight of how te solution looks like when implemented.

## Requirements

For our implementation we want to choose a method that is:

- Easy to expand in the future with additional variables.
- Has a clean implementation and allows to have a good maintainability.
- Does not break the existing library when implemented.

At the moment of writing the following three variables are expected to be added to the current library call: 

- Rollbar access token
- Permission boolean
- Fulcro state or this

## Options

**Adding variables to existing logger calls**

Adding variables is the most obvious option available. 
This means that all the times the library is used the three or more values need to be added to each call.
Since the library is already in use by one app and, the other 2 libraries in this project this update wil resort in a lot of breaking changes.

The pros of this solution is that it is relative easy to implement from an architectural standpoint. 
This comes at the cost of expandability in the future, With this solution every variable has to be put tru all the functions in the library as an argument. 
This wil make expanding later on as new features are added more difficult and error prone.

The new function call with this option wil look like:

```Clojure
(log/debug {:message "this is an example"} token permission fulcroState)
```

**Optional map**

It is possible to introduce optional variables to a function. This wil allow the option of giving details about the external logging service.
It gives the developer the control to choose if he wants a error message to potentially go to Rollbar.
While not introducing breaking changes.

By adding a map the function call will look like this:
```Clojure
(log/debug {:message "this is an example"} {:token token :permission permission :fulcro fulcroState}  )
```

By using a second map as the optional data type it is easy to introduce new variables to the logging service. 
And wil make them easily accessible inside the library without having manually pass them through each function to where the variable is needed.

It wil also leave the option open to have the optional map in a preconfigured state where a part of the data is already files in for the developer with an additional but optional namespace to the project implementing this library. This wil make it easier for the developer to use while offering full control over what gets send.
Using a general preconfigured map in a separate namespace will also improve the maintainability of the project since a lot of changes can be done in 1 place, while effecting al the library calls needed.

A call using this preconfiged namespace could look something like:

```Clojure
(log/debug {:message "this is an example"}  (loggerConfig/getPreconfigeredRollbarConfig))
```

**Separating the logging service from the existing log code**

Keeping the implementation of the external logging service separate we can keep the option to keep the existing logging call. 
And adding a second one when the developer wants this event to go to the external logging service.
This had the benefit of not introducing breaking changes to the projects that are currently implementing this library already.
An example in code if this implementation wil look something like:

```Clojure
(log/debug {:message "this is an example"} token permission fulcroState)
(log/debugToService token permission fulcroState)
```

This adds the option to keep the internal implementation of the logger separate. 
This however wil introduce either dependencies between the two sides, or causes code to be writing twice.
The code subject to being repeated is code that currently process the error message to a prettier form for display in the log will have to be redone or depended on. 
This is a lot of potential work that will also have a negative effect on the maintainability of the library.

Another advantage of this solution is that the developer can choose what error message get potentially send to the external logging service.

This option also allows the option to use a map instead of 3 variables it will give this solution the benefits of making future expansion easier and allowing for an easy to make preconfigured namespace.

## Decision

The chooses option to implement is the optional map. 
Given the situation it is the best option given it meets our requirements and allows the developer the most flexibility. It also causes the smallest impact to the maintainability of the library and to the difficulty of future expansion.

The option to simply add the variables to the existing call wil cause a lot of work during development of the library, and the update to this version of the library in other projects.
It wil also make future expandability harder compared to the option of an optional map harder and more error prone. 
Given of these disadvantages this option in not chosen.

The option to separate the logging service from the existing log code completely was not chosen due to.
The fact that we want to use existing code cause a dependency between to who, and the potential rust of introducing duplicate functions.
It also offers no advantages over the chosen solution. since it shares the same flexibility options.
