(ns com.avisi-apps.gaps.rollbar.core
  (:require
    [hyperfiddle.rcf :refer [tests]]
    [com.avisi-apps.gaps.rollbar.api :as api]))

(defn validateRollbarConfig [rollbarConfig]
  (if (and (contains? rollbarConfig :token) (string? (get rollbarConfig :token)))
    true
    false))

(defn logAdditionalInformation [rollbarConfig severity message]
  (when (validateRollbarConfig rollbarConfig)
    (api/sendToRollbar rollbarConfig severity message)))


(tests
  "testjdhjd: Should be valid config"
  (validateRollbarConfig {:token "testToken"}) := true
  "Should be invalid config, token is wrong dataType"
  (validateRollbarConfig {:token 123}) := false
  "Should be invalid config, missing the :token key"
  (validateRollbarConfig {:randomKey "testValue"}) := false)
