(ns platform-order.console
  (:require [clj-time.local :refer [local-now]]
            [clojure.pprint :refer [pprint]]
            [platform-order.storage :refer [fetch]]
            [medley.core :refer [dissoc-in]]))

(def truncate-len 40)

(defmulti truncate (fn [s] (> (count s) truncate-len)))
(defmethod truncate true [s] (str (subs s 0 truncate-len) "..."))
(defmethod truncate false [s] s)

(defmulti print-queue* empty?)
 
(defmethod print-queue* true [_]
  (println "Empty!"))

(defmethod print-queue* false [q]
  (doseq [{:keys [meta-data func args]} q]
    (println {:id (:id meta-data)
              :func func
              :in-at (:in-at meta-data)
              :failures (:failures meta-data)
              :failure-message (str "\"" (-> meta-data :failure-message truncate) "\"")})))

(defn print-queue
  "Prints a list of things in the queue."
  [adapter]
  (println "Queue at: " (str (local-now)))
  (print-queue* (fetch adapter))
  (println "==="))

(defmulti print-task* nil?)
 
(defmethod print-task* true [_]
  (println "No task by that id!"))

(defmethod print-task* false [t]
  (pprint t))

(defn- find-task [q id]
  (first (filter #(= (get-in % [:meta-data :id]) id) q)))

(defn print-task
  "Prints information on an entire task."
  [adapter id]
  (-> (fetch adapter)
      (find-task id)
      (print-task*)))

(defn- remove-task [q id]
  (remove #(= id (get-in % [:meta-data :id])) q))

;; TODO: No longer works with the list queue
;; (defn delete-task!
;;   "Delete a task."
;;   [adapter id]
;;   (->> (-> (fetch adapter)
;;            (remove-task id))
;;        (save! adapter)))

;; TODO: No longer works with the list queue
;; (defn- reset-task* [q id]
;;   (let [new-q (remove-task q id)]
;;     (-> (find-task q id)
;;         (dissoc-in [:meta-data :failures])
;;         (dissoc-in [:meta-data :last-failed-at])
;;         (dissoc-in [:meta-data :failure-message])
;;         (cons new-q))))

;; TODO: No longer works with the list queue
;; (defn reset-task!
;;   "Clears failure information, and moves task to the front of the line."
;;   [adapter id]
;;   (->> (-> (fetch adapter)
;;            (reset-task* id))
;;        (save! adapter)))

;; (require '[platform-order.queue :refer [queue]])
;; 
;; (def task {:meta-data {:id "abcd123"
;;                        :in-at "My time"
;;                        :failures 1
;;                        :last-failed-at "Another time"
;;                        :failure-message "Something really bad happened and then it happened again."}
;;            :func :this.namespace/func
;;            :args [1 2 3]})
;; 
;; (def q (queue [task (assoc-in task [:meta-data :id] "jfk87")]))
