(ns utils.schema
  (:require [schema.core :as s]))

(defn between
  "That a string's length is between x and y in length, inclusively."
  [x y]
  (s/pred (fn [v]
            (and (>= (count v) x)
                 (<= (count v) y)))))

(def email
  (s/pred
    (fn [v] (boolean (re-matches #"^[^@]+@[^@\\.]+[\\.].+" v)))))

(def Fn
  (s/pred
    (fn [f] (fn? f))))
