(ns utils.schema
  (:require [schema.core :as s]))

(defn- between-number [v x y]
  (and (>= v x)
       (<= v y)))

(defprotocol Schema
  (between-pred [v]))

(extend-protocol Schema
  String
  (between-pred [v]
    (fn [x y]
      (and (>= (count v) x)
           (<= (count v) y))))
  
  Long
  (between-pred [v]
    (fn [x y] (between-number v x y)))
   
  Integer
  (between-pred [v]
    (fn [x y] (between-number v x y))))

(defn between
  "That a String's length or a Number's size is between x and y in length, inclusively."
  [x y]
  (s/pred #((between-pred %) x y)))

(def email
  (s/pred
    (fn [v] (boolean (re-matches #"^[^@]+@[^@\\.]+[\\.].+" v)))))

(def Fn
  (s/pred
    (fn [f] (fn? f))))
