(ns utils.ring
  (:require [ring.util.response :refer [response header]]
            [utils.core :refer [records->csv]]))

(defn as-csv
  [records & [filename]]
  (-> (records->csv records)
      (response)
      (header "Content-Type" "text/csv")
      (header "Content-Disposition" (str "attachment; filename=\"" (or filename "records") "\""))))
