(ns utils.auth
  (:require [clj-http.client :refer [post]]
            [cemerick.url :refer [url]]))

(defn universal-access-url
  "Returns an authentication url (a URL complete with an access token)
  for access to the Platform teacher or student interface."
  [universal-endpoint redirect-uri client-id client-secret username]
  (let [query (->> (post universal-endpoint
                     {:form-params {:client_id client-id
                                    :client_secret client-secret
                                    :username username}})
                   (:body)
                   (assoc {} :access_token))]
    (-> (url redirect-uri)
        (assoc :query query)
        (str))))
