/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.bucket;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.bucket.DomainBucket;
import com.basho.riak.client.builders.DomainBucketBuilder;
import com.basho.riak.client.builders.RiakObjectBuilder;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.convert.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakBucket {
    private final DomainBucket<IRiakObject> delegate;
    private final Bucket bucket;

    public static RiakBucket newRiakBucket(Bucket b) {
        DomainBucketBuilder<IRiakObject> builder = DomainBucket.builder(b, IRiakObject.class);
        builder.withConverter(new Converter<IRiakObject>(){

            @Override
            public IRiakObject toDomain(IRiakObject riakObject) throws ConversionException {
                return riakObject;
            }

            @Override
            public IRiakObject fromDomain(IRiakObject domainObject, VClock vclock) throws ConversionException {
                return domainObject;
            }
        });
        return new RiakBucket(builder.build(), b);
    }

    private RiakBucket(DomainBucket<IRiakObject> delegate, Bucket bucket) {
        this.delegate = delegate;
        this.bucket = bucket;
    }

    public IRiakObject store(IRiakObject o) throws RiakException {
        return this.delegate.store(o);
    }

    public IRiakObject store(String key, byte[] value) throws RiakException {
        return this.delegate.store(RiakObjectBuilder.newBuilder(this.bucket.getName(), key).withValue(value).build());
    }

    public IRiakObject fetch(String key) throws RiakException {
        return this.delegate.fetch((IRiakObject)((Object)key));
    }

    public IRiakObject fetch(IRiakObject o) throws RiakException {
        return this.delegate.fetch(o);
    }

    public void delete(IRiakObject o) throws RiakException {
        this.delegate.delete(o);
    }

    public void delete(String key) throws RiakException {
        this.delegate.delete(key);
    }
}

